<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\my_school_data;
use App\models\arm;
use App\models\Exams\exam;
use App\models\house;
use App\models\lesson_note;
use App\models\sch_class;
use App\models\Staff_class;
use App\models\subject;
use App\models\subject_group;
use App\models\subject_result;
use Illuminate\Http\Request;

class Class_subjectController extends Controller
{
    use my_school_data;

    function store_class(Request $request)
    {
        $store = sch_class::updateOrCreate( $request->except('api_token') );
        $this->activity_log("Added a New Class with title - ". request()->name);
        return ( ! $store ) ? $this->error_msg() : $this->success_msg() ;
    }

    function store_subject(Request $request)
    {
        $store = subject::updateOrCreate( $request->except('api_token') );
        $this->activity_log("Added a New Subject with title - ". request()->name );
        return ( ! $store ) ? $this->error_msg() : $this->success_msg() ;
    }
    
    function store_arm(Request $request)
    {
        $store = arm::updateOrCreate( $request->except('api_token') );
        $this->activity_log("Added a New Sub-class/Arm with title - ". request()->name );
        return ( ! $store ) ? $this->error_msg() : $this->success_msg() ;
    }

    function store_houses(Request $request)
    {
        $store = house::updateOrCreate( $request->except('api_token') );
        $this->activity_log("Added a New School House with title - ". request()->name ); 
        return ( ! $store ) ? $this->error_msg() : $this->success_msg() ;
    }

    function delete_classes()
    {
        $data = request()->id;
        $msg = ( count($data) == 1) ? "Deleted a Class " : "Deleted ".count($data)." Classes" ;
        $this->activity_log($msg);
        return ( ! sch_class::destroy($data) )? $this->error_msg() : $this->success_msg('Removed Successfully...');
    }

    function delete_subjects()
    {
        $data = request()->id;
        $msg = ( count($data) == 1) ? "Deleted a Subject " : "Deleted ".count($data)." Subjects" ;
        $this->activity_log($msg);
        return ( ! subject::destroy($data) )? $this->error_msg() : $this->success_msg('Removed Successfully...');
    }

    function delete_arms()
    {
        $data = request()->id;
        $msg = ( count($data) == 1) ? "Deleted a Sub-Class/Arm" : "Deleted ".count($data)." Arms/Sub-Classes" ;
        $this->activity_log($msg);
        return ( ! arm::destroy($data) )? $this->error_msg() : $this->success_msg('Removed Successfully...');
    }

    function delete_houses()
    {
        $data = request()->id;
        $msg = ( count($data) == 1) ? "Deleted a School House " : "Deleted ".count($data)." School Houses " ;
        $this->activity_log($msg);
        return ( ! house::destroy($data) )? $this->error_msg() : $this->success_msg('Removed Successfully...');
    }

    function store_subject_group()
    {
        $store = subject_group::updateOrCreate( request()->except('api_token') );
        $this->activity_log("Added a New Subject Group/Category with title - ". request()->name );
        return ( ! $store ) ? $this->error_msg() : $this->success_msg();
    }

    function delete_subject_group()
    {
        $data = request()->id;
        $msg = ( count($data) == 1) ? "Deleted a Subject Group/Category" : "Deleted ".count($data)." Subject Groups/Categories" ;
        $this->activity_log($msg);
        return ( ! subject_group::destroy($data) )? $this->error_msg() : $this->success_msg('Removed Successfully...');
    }

    function update_school_subjects()
    {
        if( request()->name == '') return $this->error_msg('Subject name should not be empty');
        $subject_id = request()->id;
        $subject_new_name = ucwords( strtolower(request()->name) );
        $subject_old_name = $this->subject_name( $subject_id );
        $this->update_subject_name_in_other_tables( $subject_old_name, $subject_new_name );
        $update = $this->user(new subject, $subject_id)->update( request()->all() );
        $this->activity_log(" Updated ".$subject_old_name .' to '. $subject_new_name .' with Subject Group/Category');
        return (! $update ) ? $this->error_msg() : $this->success_msg();
    }

    function subject_name( $subject_id )
    {
        $subject = $this->my_school(new subject)->whereId( $subject_id )->first();
        return $subject ? $subject->name : '';
    }

    function update_subject_name_in_other_tables($subject_old_name, $subject_new_name)
    {
        //Places where Subject names appear, update them all
        $this->my_school(new subject_result)->whereSubjects( $subject_old_name )->update(['subjects' => $subject_new_name ]);
        $this->my_school(new exam)->whereSubject( $subject_old_name )->update(['subject' => $subject_new_name ]);
        $this->my_school(new Staff_class)->whereSubjects( $subject_old_name )->update(['subjects' => $subject_new_name ]);
        $this->my_school(new lesson_note)->whereSubject( $subject_old_name )->update(['subject' => $subject_new_name ]);
    }
    
}
